//	CDialogGetInfo.h

#ifndef _H_CDialogGetInfo
#define	_H_CDialogGetInfo

#include "CDialog.h"
#include "CEntry.h"
#include "COffscreen.h"

/*
	Conventions:
	
	_USER_	user item
	_STAT_	static text (set in resource)
	_VERB_	verbage, a static text that is set/updated by program
	_EDIT_	edit text
	_POP_	popup menu

	_USER_GROUP_	user item that simply draws a beveled border around itself, for grouping items
	_USER_ERASE_	item will simply erase itself
	_UC_	user item checkbox (the actual square with/out the "X")
	_SC_	static text checkbox (the text of the checkbox)
	_UCE_	user item checkbox enclosure (the area in which a click is valid for the check)
*/

typedef enum {
	ADFS_GetInfo_NONE, 
	
	ADFS_GetInfo_USER_ICON, 
	ADFS_GetInfo_USER_ICON_OUTLINE, 
	
	ADFS_GetInfo_VERB_NAME, 
	
	ADFS_GetInfo_STAT_KIND,			ADFS_GetInfo_VERB_KIND, 
	ADFS_GetInfo_STAT_SIZE,			ADFS_GetInfo_VERB_SIZE, 
	ADFS_GetInfo_STAT_USED,			ADFS_GetInfo_VERB_USED, 
	ADFS_GetInfo_STAT_WHERE,		ADFS_GetInfo_VERB_WHERE, 
	ADFS_GetInfo_STAT_CREATED,		ADFS_GetInfo_VERB_CREATED, 
	ADFS_GetInfo_STAT_MODIFIED,		ADFS_GetInfo_VERB_MODIFIED, 
	ADFS_GetInfo_STAT_STORAGE,		ADFS_GetInfo_VERB_STORAGE, 
	ADFS_GetInfo_STAT_TYPE,			ADFS_GetInfo_EDIT_TYPE,		//	19
		ADFS_GetInfo_POPUP_DOS_TYPE, 
		ADFS_GetInfo_POPUP_PRO_TYPE, 
		ADFS_GetInfo_POPUP_PAS_TYPE, 
		ADFS_GetInfo_POPUP_CPM_TYPE, //	23
		
	ADFS_GetInfo_STAT_AUXTYPE,		ADFS_GetInfo_EDIT_AUXTYPE,

	ADFS_GetInfo_UCE_LOCKED_HIT, 

	ADFS_GetInfo_UCE_DESTROY,	ADFS_GetInfo_UC_DESTROY,		ADFS_GetInfo_SC_DESTROY,
	ADFS_GetInfo_UCE_RENAME,	ADFS_GetInfo_UC_RENAME,			ADFS_GetInfo_SC_RENAME,
	ADFS_GetInfo_UCE_WRITE,		ADFS_GetInfo_UC_WRITE,			ADFS_GetInfo_SC_WRITE,
	ADFS_GetInfo_UCE_BACKUP,	ADFS_GetInfo_UC_BACKUP,			ADFS_GetInfo_SC_BACKUP,
	ADFS_GetInfo_UCE_READ,		ADFS_GetInfo_UC_READ,			ADFS_GetInfo_SC_READ,

	ADFS_GetInfo_USER_GROUP_LOCKED, ADFS_GetInfo_USER_ERASE_LOCKED,	//	43

	ADFS_GetInfo_UCE_LOCKED,	ADFS_GetInfo_UC_LOCKED,			ADFS_GetInfo_SC_LOCKED,
	
	ADFS_GetInfo_POP_SHOW_HIT,
	ADFS_GetInfo_USER_GROUP_SHOW,	ADFS_GetInfo_USER_ERASE_SHOW,	
	ADFS_GetInfo_POP_SHOW_DRAW, //	50
	
	ADFS_GetInfo_USER_PREVIEW,
	
	ADFS_GetInfo_NUMTYPES
} ADFS_GetInfoType;

#define		ADFS_GetInfo_FIRST_GEN_GROUP			ADFS_GetInfo_STAT_KIND
#define		ADFS_GetInfo_LAST_GEN_GROUP				ADFS_GetInfo_SC_LOCKED

#define		ADFS_GetInfo_FIRST_PREVIEW_GROUP		ADFS_GetInfo_USER_PREVIEW
#define		ADFS_GetInfo_LAST_PREVIEW_GROUP			ADFS_GetInfo_USER_PREVIEW

#define	kGetInfoPopCNTL_ID	130

#define	kGetInfoTypeCNTL_ID	131

enum	{
	kGetInfoMenuItem_GENERAL = 1,
	kGetInfoMenuItem_PREVIEW
};

typedef enum {
	ADFS_GetInfoCheck_DESTROY, 
	ADFS_GetInfoCheck_RENAME, 
	ADFS_GetInfoCheck_WRITE, 
	ADFS_GetInfoCheck_BACKUP, 
	ADFS_GetInfoCheck_READ, 
	
	ADFS_GetInfoCheck_LOCK, 
	
	ADFS_GetInfoCheck_NUMTYPES
} ADFS_GetInfoCheckType;

#define	GI_Check2Item(check)	(ADFS_GetInfoType)(			\
	check == ADFS_GetInfoCheck_LOCK 						\
		? ADFS_GetInfo_UC_LOCKED 							\
		: ADFS_GetInfo_UC_DESTROY + (3 * (check)))
		
#define	GI_Item2Check(item)		(ADFS_GetInfoCheckType)(	\
	item == ADFS_GetInfo_UC_LOCKED 							\
		? ADFS_GetInfoCheck_LOCK : 							\
		((item) - ADFS_GetInfo_UC_DESTROY) / 3)

class	CEntry;
class	CDialogGetInfo;

/*************************************************/
extern	CDialogGetInfo		*gGetInfoP;

CDialogGetInfo		*ShowGetInfo(CEntry *entryP, Boolean showPreviewB);
CDialogGetInfo		*GetGetInfo(void);
void				HideGetInfo(void);

class CDialogGetInfo	 : public CDialog {
	
	public:	Boolean		IGetInfo(CEntry *entryP, Boolean showPreviewB);
			void		SetGetInfoTypeAndAux(void);
			void		SetGetInfoEntry(CEntry *entryP, Boolean showPreviewB);
			void		SwapShowInfo(void);
			void		SetLockBits(void);

	virtual	void		Dispose(void);
	virtual	void		SetDialogFont(void);

	virtual	void	Move(EventRecord *event);
	virtual	void	DialogItemStandardDrawProc(
		DialogItemIndex	itemNo, 
		Rect			*itemRectP);

	virtual	Boolean		DoCommand(long command);
	virtual	void		DoKeyDown(EventRecord *theEvent);
	virtual	void		DoClick(EventRecord *theEvent);
	virtual	void		UpdateMenus(void);

	Boolean				TrackCheck(short itemHit);
	void				DrawCheck(short itemHit, Boolean trackingB);
	ushort				VerifyText(short itemHit, TERestoreRec *restoreRec0);
	void				CancelText(short itemHit);
	virtual	ControlRef	GetDlogItemControl(short dlgItem);

	static	void		CB_S_GetInfo_Offs(
		OffscreenCBType cbType, 
		OffscreenCBData	*cbData, 
		void			*cbRefcon);

	void	CB_GetInfo_Offs(
		OffscreenCBType cbType, 
		OffscreenCBData	*cbData);
		
	void				ClearPreviewRec(void);
	
	/*****************************************/
	CEntry			*i_entryP;
	
	ControlRef		i_showPop;

	short			i_curPopType;
	ControlRef		i_typePops[4];

	Boolean			i_showPreviewB;
	Boolean			i_checked[ADFS_GetInfoCheck_NUMTYPES];
	
	char			i_fileTypeStrA[256];
	char			i_auxTypeStrA[256];
	
	ADFS_PreviewRec	i_previewRec;

	private:
	typedef 	CDialog		_inherited;
};

#endif
